Attribute VB_Name = "adt8949G1"
Option Explicit
    '******************************Base parameters settings****************************
    '/************************************************
    'Function     Initialize motion card
    'Returnsreturn>0Return value is the quantity of adt-8949 cards in the systemValue 3 indicate that three cards have been installed and available card number are 0 1 and 2ĿÿŷֱΪ012
    '         return=0Value 0 indicates that no adt8949 card has been installed
    '         return<0value -1 indicates that the drivers of adt-8949 card haven't been installed
    '                         -2 Indicates faulty PCI bridge
    '                         -3 Indicates that DSP program download error
    '                         -4 indicate hardware error or mismatched dll version
    '                         -5 failed to create the mutex
    '                         -6 open the mutex failed
    '                         -7 other anomailes
    Declare Function adt8949_initial Lib "adt8949.dll" () As Long

    '/************************************************
    'Function     release the sources of the motion card
    'Return0 success ,-1 failure
    'Remarks     when call the functionmotion card will resetclear all the motion commandand clear all the output
    '           when program with VB6.0 , the execute program will exit abnormal without this API
    '************************************************/
    Declare Function adt8949_close_card Lib "adt8949.dll" () As Long

    '/************************************************
    'Function     Get the version of library function
    'Returnthe version number of the library function
    'Remarks     8949G1Drive library version number and firmware version number two version information, the same firmware version there may be a different driver library distribution, so once the problem back to pay attention to the two versions of the information.

    '              adt8949 has library version and firmware version, one firmware version may has many library version, so, please notice the two version
    '************************************************/
    Declare Function adt8949_get_lib_version Lib "adt8949.dll" () As Long

    '/************************************************
    'FunctionGet current firmware version
    'Para:      cardno : Card number
    'Return   Return value contains the information of firmware version and card ID.
    '           The first five digits indicate card DIP ID.
    '           The last 27 digits indicate the firmware version
    'Remarks ADT-8949 has driver library version number and firmware version number. The same firmware version may have different driver library version, so pay attention to the information of both version numbers for problem tracing.
    '************************************************/
    Declare Function adt8949_get_firmware_ver Lib "adt8949.dll" (ByVal cardno As Long) As Long
    
    '/************************************************
                'Function access to current available card number dial the code switch
                'Parameter
                '       num             available card number pointer
                '       index   number dial the code switch
                'Return         0correct                               non-zero: error
                'Remarks After the success of the initialization can call this function to get dial the code switch;
'

                '             In accordance with the order of the close to the CPU, dial the code switch, arranged in order, such as the index [0] represent the most close to the CPU dial the code switch, index [1] second,...

                '************************************************/
    Declare Function adt8949_get_card_index Lib "adt8949.dll" (ByRef num As Long, ByRef index As Long) As Long

    '/****************************************************
                'FunctionGet the latest error number of the system
                'Parameter settings
                '       cardno      Card number
                '       ErrNum      Pointer of the system error number
                'Remark: Get system error number regularly, and view the running of the motion card
                '******************************************************/
     Declare Function adt8949_get_syserr Lib "adt8949.dll" (ByVal cardno As Long, ByRef ErrNum As Long) As Long
    
    
    '/********************************************************
                'Functionread the communication error
                'Parameter
                '       cardno         card number
                '       type            0: Control card terminal           1 patch panel

                'ErrCount      Communication error number pointer

                'Return         0correct                               non-zero: error

                'Remarks Control card with patch panel in the case of power cuts can make mistake number zero;

                '               Communication error number is not zero does not mean control card output error, check failures communication data automatically.

                '*********************************************************/
    Declare Function adt8949_get_communication_err Lib "adt8949.dll" (ByVal cardno As Long, ByVal mode As Long, ByRef ErrCount As Long) As Long



    '/****************************************************
                'FunctionReset motion card
                'Parameter
                '       cardno      card number
                'Return                 0correct                 -1wrong
                'After calling this function, the control will clear all cache events and motion instruction data; if synchronized axis has been set, the synchronization relationship of axes will also be cleared, but limit, acceleration, gear ratio and other motion parameters that have been set won't be cleared, and do not need to re-set;
                'When the machine has external emergency stop, positive/negative limit or abnormal stop, or before cache interpolation of large amount of data, it is recommended to call the function to reset the control card.
                '******************************************************/
    Declare Function adt8949_reset_card Lib "adt8949.dll" (ByVal cardno As Long) As Long

    '/************************************************
                'Function: Set total speed rate
                'Parameter:
                '       cardno       Card number
                '       rate         Rate (0~2.0)
                'Return: 0 correct,-1 wrong
                'Remarks: Refresh immediately; if the rate of change is too large, it will cause speed step;
                'the ideal method is to set timing gradually to produce a deceleration effect; when the rate is set to 0, the effect is equivalent to suspend.
                '***********************************************/
    Declare Function adt8949_set_rate1 Lib "adt8949.dll" (ByVal cardno As Long, ByVal rate As Single) As Long

    '/***************************************************************
                'Function:  Set speed rate of each axis
                'Parameter:
                '       cardno      Card number
                '       axis        Axis number :Ax,Ay,Az,Aa,INPA_AXISREG, INPB_AXISREG
                '       rate        Rate (0~2.0)
                'Return: 0 correct , -1 wrong
                'RemarksRemark: After calling this function, the speed rate of the axis will refresh immediately, so if the rate of change is too large,
                'it will cause speed step; the ideal method is to set timing gradually to produce a deceleration effect.
                '****************************************************************/
    Declare Function adt8949_set_rate2 Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal rate As Single) As Long

    '/*****************************************************************
                'Function:  Set the electronic gear ratio of each axis,
                'Parameter:
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       gear        Gear ratio(1-10000)the pulses corresponding to 1mm Default: 1000, i.e. 1000 pulses moves 1mm
                'Return: 0 correct, -1 wrong
                'RemarksGear ratio value for floating point number

                '******************************************************************/
    Declare Function adt8949_set_gear Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal gear As Single) As Long

    '/**********************************************************
                'Function:  Axis cache position and logic position synchronization
                'Parameter:
                '       cardno      Card number
                '       axismap     Axis mapping bitbit0 indicate axis 1bit1 indicate axis 2bit2 indicate axis 3bit3 indicate axis 4
                'Return: 0 correct,-1 wrong
                'RemarksSet after zeroing and tool setting and before one group of interpolation motion to improve accuracy. Do not set when the machine is in motion.
                '**********************************************************/
    Declare Function adt8949_set_syncpos Lib "adt8949.dll" (ByVal cardno As Long, ByVal axisbit As Long) As Long

    '/*************************************************
                'FunctionSet the work mode of output pulse
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       value       0pulse + pulse   1pulse + direction  290Phase difference 2 phase pulse encoder (simulation) A + B phase

                '       logic       0 positive logic pulse             1negative logic pulse
                '       dir_logic   0positive logic direction signal   1negative logic direction signal
                'Return             0correct                              -1wrong
                'Default modespulse + directionpositive logic pulsepositive logic direction signal
                '**************************************************/
    Declare Function adt8949_set_pulse_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal Value As Long, ByVal logic As Long, ByVal dir_logic As Long) As Long

    '/*************************************************
                'FunctionSet the working mode of actual position counter (encoder input)
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4),
                '       value       0A/B pulse input      1up/down (PPIN/PMIN) pulse input
                '       dir_logic   count direction0: input signal direction positive logic,   1: input signal direction negative logic
                'Return             0correct              -1wrong
                'Default modesA/B pulse input input signal direction positive logic
                'RemarksWhen it is set to A/B phase pulse input, the pulse count is the data by 4 times frequency multiplication
                '**************************************************/
    Declare Function adt8949_set_actual_count_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal Value As Long, ByVal dir_logic As Long) As Long

    '/****************************************************
    'FunctionSet the mode of positive/negative limit input signal nLMT
    'Para
    'cardno     card number
    'axis           axis number(1-4)
    'v1          0positive limit valid                      1positive limit invalid
    'v2          0negative limit valid                      1negative limit invalid
    'logic       0low level valid                      1high level valid
    'Return                 0success                                 1failure
    'default modespositive limit valid negative limit valid low level valid
    '*****************************************************/
    Declare Function adt8949_set_limit_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal v1 As Long, ByVal v2 As Long, ByVal logic As Long) As Long
    
    '/****************************************************
                'FunctionSet positive/negative limit mode
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       v           0Inactive                 1Active
                '       logic       0Low level active         1High level active
                '       admode      0Deceleration stop        1Immediate stop
                'Return             0correct                  -1wrong
                'Default modes stop0 inactive
                'Remarksstop0 signal is mechanical origin , XHM/IN12, YHM/IN13, ZHM/IN14, AHM/IN15
                '*****************************************************/
     Declare Function adt8949_set_stop0_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal v As Long, ByVal logic As Long, ByVal admode As Long) As Long
    
    '/****************************************************
                'FunctionSet positive/negative limit mode
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       v           0 Inactive                        1Active
                '       logic       0Low level active                 1High level active
                '       admode          0Deceleration stop            1Immediate stop
                'Return                 0correct                      -1wrong
                'Default modes Inactive
                'Remarksstop1 is servo origin or Z-phase signal, IN44, IN45, IN46, IN47
                '******************************************************/
     Declare Function adt8949_set_stop1_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal v As Long, ByVal logic As Long, ByVal admode As Long) As Long

                '/****************************************************
                'Functionset soft limit mode
                'Parameter
                '       cardno                  card number
                '       axis                    axis(1-4)
                '       EnableFlag      0invalid                 1valid
                '       Ppos                   Positive direction trigger position, the unit is mm

                '       Npos                    Negative direction trigger position, the unit is mm

                '       admode                  0 deceleration stop          1immediate stop
                'Return                         0corret                 -1wrong
                'Default modessoft limit invalid
                '*****************************************************/
                Declare Function adt8949_set_softlimit_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal EnableFlag As Long, ByVal Ppos As Single, ByVal Npos As Single, ByVal admode As Long) As Long

    '****************************************************
                'FunctionSet input signal mode (including positive/negative limit, home)
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       mode        0: Positive limit, 1: Negative limit      2Home (or encoder Z phase signal)
                '       port        Input port number quickly (0-18, 36-47), 255or -1:
                '                   Set corresponding mode to inactive; in addition,
                '                   the corresponding ports of encoder signals (phase A, B & Z) of the four driving axes:
                '                   IN36IN39:     A1...A4
                '                   IN40IN43:     B1...B4
                '                   IN44IN47:     Z1...Z4
                '       logic       Active voltage level: 0: Low level active,  1: High level active
                '       admode      Whether use deceleration when limit is active, 0: deceleration stop; 1: immediate stop
                'Return                 0correct                                -1wrong
                'RemarksTo facilitate the setting of machine limit, home, and servo phase-Z signal, the following functions have been packaged: adt8949_set_limit_mode(), adt8949_set_stop0_mode(), adt8949_set_stop1_mode()
                '         The default mode is: Positive limit low level active, negative limit low level active, home signal (or encoder Z-phase signal) inactive;
                '         Positive and negative limit temporarily support the immediate stop mode only;
                '         The home or encoder Z-phase signal mode used for homing can't be enabled at the same time. You can set homing first and then reset encoder Z-phase.

                '*****************************************************/
    Declare Function adt8949_set_input_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal mode As Long, ByVal port As Long, ByVal logic As Long, ByVal admode As Long) As Long

    '/****************************************************
                'Functionset the mode of hardstop signal
                'Parameter
                '       cardno      Card number
                '       port        input port number quickly (0-18, 36-47), 255 or -1: set corresponding mode to inactive
                '       logic       active voltage level   0: Low level active, 1: High level active
                'Return             0correct                                -1wrong
                'RemarksRemark: Emergency stop is inactive by default. Once external emergency stop is active, you need to call adt8949_reset_card() to reset the motion card,
                'or else the calling of any motion instruction will be inactive even if the emergency stop active level has been canceled.
                '*****************************************************/
    Declare Function adt8949_set_emergency_stop_mode Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long, ByVal logic As Long) As Long

    '/*************************************************
                'FunctionSet the position latch function

                'Parameter
                '       cardno      card number
                '       axis           Shaft number (1-4), of which the corresponding shaft specified port is:
                '                                       1axis:IN12
                '                                       2axis:IN13
                '                                       3 axis: IN14
                '                                       4 axis: IN15
                '       logic          Effective level, single along when change: 0 means from high to low, 1 from low to high

                '                                               Double along the vt: 0 indicates the change from high to low for the first time, second time along the change from low to high; 1 for the first time along the change from low to high, the second time along the change from high to low

                '       type            1Single along the latches change, 2 pairs along the latches

                'Return                 0correct -1error

                'Default modesLatch function is invalid

                'RemarksPosition latch function when triggered, will at the same time record down the variation signal at the time of the logic and the actual location.

                '         The function is enabled, the limit of time, if the location of the need to capture the change occurs again, need to ensure that cleared the last time the latch state, and enable the position latch function again.

                '*****************************************************/
    Declare Function adt8949_set_lock_position Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal logic As Long, ByVal mode As Long) As Long

    '/*************************************************
                'FunctionTo obtain position latched condition

                'Parameter
                '       cardno     The card number

                '       axis        axis number (1-4), of which the corresponding shaft specified port is:

                '                                       1axis:IN12
                '                                       2axis:IN13
                '                                       3axis:IN14
                '                                       4axis:IN15
                '       type            1Said to get first along the position latch state change, 2 said along the change will require a second position when the latch state (for double along the position latch)

                '       v                       0Latches action did not happen, 1: latch action has occurred

                'Return                 0correct    -1error


                '*****************************************************/
    Declare Function adt8949_get_lock_status Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal mode As Long, ByRef sta As Long) As Long

    '/*************************************************
                'FunctionTo obtain position latched position

                'Parameter
                '       cardno     card number
                '       axis            axis number (1-4), of which the corresponding shaft specified port is:

                '                                       1 axis:IN12
                '                                       2axis:IN13
                '                                       3axis:IN14
                '                                       4axis:IN15
                '       type            0x10Said to get logical location for the first time along the change occurs

                '                               0x11show get the actual position for the first time along the change occurs

                '                               0x20show obtain second time along the change occurs in the logic of the position (for double edge position latch)

                '                               0x21show  get second time along the change occurs when the actual location of the (for double along the position latch)

                '       pos                     To obtain a pointer to the position

                'Return                 0correct     -1error

                '*****************************************************/
    Declare Function adt8949_get_lock_position Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal mode As Long, ByRef pos As Long) As Long

    '/*************************************************
                'FunctionRemove lock state

                'Parameter
                '       cardno      card number
                '       axis          axis  number (1-4), of which the corresponding shaft specified port is:

                '                                       1 axis:IN12
                '                                       2 axis:IN13
                '                                       3 axis:IN14
                '                                       4 axis:IN15
                'Return                 0correct                                -1error
                '*****************************************************/
    Declare Function adt8949_clr_lock_status Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long) As Long

    '/*************************************************
                'FunctionSet extension position latch function

                'Parameter
                '       cardno     card number
                '       axis            The axis number(1-4)
                '       port            Port(17-18)
                '       logic           Effective level, single along when change: 0 means from high to low, 1 from low to high

                '                                                Double along the vt: 0 indicates the change from high to low for the first time, second time along the change from low to high; 1 for the first time along the change from low to high, the second time along the change from high to low

                '       type           1 single along the latches, 2 said double along the latches

                'Return                 0correct                                -1error
                'Default modesLatch function is invalid

                'RemarksPosition latch function when triggered, will at the same time record down the variation signal at the time of the logic and the actual location.

                '         The function is enabled, the limit of time, if the location of the need to capture the change occurs again, need to ensure that cleared the last time the latch state, and enable the position latch function again.

                '*****************************************************/
    Declare Function adt8949_set_EXlock_position Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal port As Long, ByVal logic As Long, ByVal mode As Long) As Long

    '*************************************************
                'FunctionFor extended position latched condition

                'Parameter
                '       cardno      card number
                '       port           port(17-18)
                '       type            1 said to get first along the position latch state change, 2 said along the change will require a second position when the latch state (for double edge position latch)

                '       v                       0: latches action did not happen, 1: latch action has occurred

                'Return                 0correct                               -1error
                '*****************************************************/
    Declare Function adt8949_get_EXlock_status Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long, ByVal mode As Long, ByRef sta As Long) As Long

    '/*************************************************
                'FunctionAccess to extension position latched position

                'Parameter
                '       cardno     card number
                '       port            port(17-18)
                '       type            0x10show  get logical location for the first time along the change occurs

                '                               0x11show get the actual position for the first time along the change occurs

                '                               0x20show get second position along the logic of change occurs along the change (for double position latches)

                '                               0x21show get second time along the change occurs when the actual location of the (for double along the position latch)

                '       pos                    To obtain a pointer to the position

                'Return                 0correct                              -1error
                '*****************************************************/
    Declare Function adt8949_get_EXlock_position Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long, ByVal mode As Long, ByRef pos As Long) As Long

    '/*************************************************
                'FunctionClear extension latch state

                'Parameter
                '       cardno      card number
                '       port            port(17-18)
                'Return                 0correct                                -1error
                '*****************************************************/
    Declare Function adt8949_clr_EXlock_status Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long) As Long
    
    '/****************************************************
                'Function: Set the filter level of input signal, The default mode is no filter for all input signals.

                'Parameter
                '       cardno      Card number
                '       gp           Input signal types
                '                    0: limit, home, common IO
                '                    1: encoder signal(A, B, Z)

                '       grade        Range: 0-15. 0 indicates no filter; if it is set to n, the filter time is 2 (n-1) us
                'Return                 0correct                                -1wrong
                'RemarksThe default mode for all input signal filtering. This function is effective to check the firmware version.

                '*****************************************************/
    Declare Function adt8949_set_input_filter Lib "adt8949.dll" (ByVal cardno As Long, ByVal gp As Long, ByVal grade As Long) As Long


    '//----------------------------------------------------//
    '//              Drive the state examination function   //

    '//----------------------------------------------------//

    '/*****************************************************
                'FunctionGet the driving status of each axis
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       v           Pointer of driving status
                '                   0 Driving ends                             1Driving
                'Return             0correct                               -1wrong
                'RemarksThis function is used to query API. For consecutive query, insert a Sleep(1) sentence between two queries
                '******************************************************/
    Declare Function adt8949_get_status Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByRef v As Long) As Long

    '/*****************************************************
                'FunctionGet driving status of all axes
                'Parameter
                '       cardno      Card number
                '       v           Pointer of driving statusbit0bit3 axis1axis4bit15 indicate INPA_AXISREG
                '                   0Driving ends                             1Driving
                'Return             0correct                                  -1wrong
                'RemarksThis function is used to query API. For consecutive query, insert a Sleep(1) sentence between two queries
                '******************************************************/
    Declare Function adt8949_get_status_all Lib "adt8949.dll" (ByVal cardno As Long, ByRef v As Long) As Long

    '/*****************************************************
                'FunctionGet driving status of interpolation
                'Parameter
                '       cardno      Card number
                '       v           Pointer of driving status
                '                   0riving ends                            1Driving
                'Return             0correct                               -1wrong
                'RemarksThis function is used to query API. For consecutive query, insert a Sleep(1) sentence between two queries
                '*****************************************************/
    Declare Function adt8949_get_inp_status Lib "adt8949.dll" (ByVal cardno As Long, ByRef v As Long) As Long

    '/*****************************************************
                'FunctionFunction: Get stop data of each axis
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       value       Pointer of stop data (0: no error stop; non-0: has limit, home or encoder Z phase signal triggers stop):
                '                   bit0==1: positive limit triggers stop
                '                   bit1==1: negative limit triggers stop
                '                   bit2==1: home signal triggers stop
                '                   it3==1: encoder Z phase signal triggers stop
                '                   bit4==1: external emergency stop signal triggers stop

                'Return                 0correct                                -1wrong
                'Remarks    Remark: Stop data may appear in combination, e.g. if both bit0 and bit1 are 1, positive limit and negative limit are triggered, resulting in axis stop
                '             For consecutive query, insert a Sleep(1) sentence between two queries, or else it will affect the efficiency of the control card.
                '*****************************************************/
    Declare Function adt8949_get_stopdata Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByRef Value As Long) As Long

    '//----------------------------------------------------//
                '//               Motion parameters setting function  //

                '//----------------------------------------------------//
                '/****************************************************
                'FunctionSet S-shaped jerk; default: 0Set axis acceleration Set axis deceleration
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4, number of interpolation axis: INPA_AXISREG)
                '       jcc         Jerk: 0~10
                '       add         Acceleration/deceleration value (1-100000),mm/sec^2
                '
                'Return                 0correct                                 -1wrong
                'Remarks    ADT-8949 supports asymmetric acceleration/deceleration; when setting acceleration, deceleration will be equal to the acceleration by default;
                '             therefore, to set the deceleration, place set_dec after set_acc, or else the deceleration value will be overwritten by acceleration.
                '*****************************************************/
    Declare Function adt8949_set_jcc Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal jcc As Long) As Long
    Declare Function adt8949_set_acc Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal add As Single) As Long
    Declare Function adt8949_set_dec Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal dec As Single) As Long


    '/****************************************************
                'FunctionSet axis start speed, end speed in sequence
                'Parameter
                '       cardno      Card number
                '       axis        1~4 single axis  INPA_AXISREG interpolation axis

                '       speed       Speed, unit: mm/sec,0.001~100000
                'Return                 0correct                                 -1wrong
                'Remarks     If endv is set before startv, default endv= startv
                '******************************************************/
    Declare Function adt8949_set_startv Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal speed As Single) As Long
    Declare Function adt8949_set_endv Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal speed As Single) As Long

    '/****************************************************
                'FunctionSet axis acceleration/deceleration mode
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4, number of interpolation axis: INPA_AXISREG )
                '       mode        Range (0-3)
                '                               0 S-shaped acceleration/deceleration mode
                '                               1 trapezoidal acceleration/deceleration mode
                '                               2 exponential acceleration/deceleration mode
                '                               3 trigonometric acceleration/deceleration mode
                '
                'Return                 0correct                                -1wrong
                'RemarksRemark: The default option is trapezoidal acceleration/ deceleration modePoint motion and single linear interpolation can use any mode,
                'Single arc interpolation uses mode 1 and 3.Spline interpolation uses mode 1.
                'To use non-trapezoidal acceleration/deceleration mode in interpolation, ensure that the segment of pretreatment cache is zero.

                '******************************************************/
    Declare Function adt8949_set_admode Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal mode As Long) As Long

    '/****************************************************
                'FunctionSet axis running speed
                'Parameter
                '       cardno      Card number
                '       axis        1~4 single axis INPA_AXISREG interpolation axis
                '       speed       Speed, unit: mm/sec,0.001~100000
                'Return                 0correct                                 -1wrong
                '******************************************************/
    Declare Function adt8949_set_speed Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal speed As Single) As Long
    
     '/****************************************************
                'FunctionSet acceleration constraint at motion path connection
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       add         Range (100-100000), default: 500mm/sec^2
                'Return                 0correct                                -1wrong
                'Remarks    In cache interpolation, it is used to set the acceleration constraint of axis; it is active in pretreatment,
                '               and limits the maximum speed change of each axis at the connection of line segments
                '             In the debugging process, constraint value can be gradually increased as long as the interpolation accuracy won't be affected,
                '             which will reduce machine shake in interpolation.
                '******************************************************/
    Declare Function adt8949_set_acc_constraint Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal add As Single) As Long

    '/****************************************************
                'FunctionSet speed constraint at motion path connection
                'Parameter
                'cardno     Card number
                'axis       1~4 single axis  INPA_AXISREG interpolation axis
                'speed      Speed, unit: mm/sec,0.001~100000
                'Return                 0correct                                -1wrong
                'Remarks    This function doesn't need to be called generally.
                '    In special process, it is used to set the maximum axis speed at the connection of two line segments in cache interpolation; it is active in pretreatment,
                '    and limits the maximum speed of each axis at the connection of line segments.
                '******************************************************/
    Declare Function adt8949_set_speed_constraint Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal speed As Single) As Long
   
    '****************************************************
                'FunctionWhen using cache interpolation, set axis acceleration constraint active in pretreatment,
                '           and limit the maximum speed changes of each axis at the connection of line segments
                'Parameter
                '       cardno      Card number
                '       radius      Radius coefficient
                '       speed       Speed coefficient, range (0.01-100000 mm/sec)
                'Default value      Radius coefficient = 10mm, speed coefficient = 100mm/sec
                'Return                 0correct                                 -1wrong
                'Remarks            The function will be active in flat arc or spatial arc interpolation;
                '                   if the function is called and the actual radius is smaller than the radius coefficient, the arc speed is less limited;
                '                   If the actual radius is larger than the radius coefficient, the arc speed limit is greater.
                '                   If the actual radius is equal to the radius coefficient, the maximum speed of arc is equal to the speed coefficient.
                '******************************************************/
    Declare Function adt8949_set_arc_speed_clamp Lib "adt8949.dll" (ByVal cardno As Long, ByVal radius As Single, ByVal speed As Single) As Long

    '/****************************************************
                'FunctionSet logic position of axis pulse
                'Parameter
                '       cardno      Card number
                '       axis        1~4 single axis
                '       pos         Logic position  Set range (-2147483648~+2147483647)
                'Return             0correct                                -1wrong
                '*****************************************************/
    Declare Function adt8949_set_command_pos Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal pos As Long) As Long

    '/****************************************************
                'FunctionSet actual position
                'Parameter
                '       cardno      Card number
                '       axis        Axis number(1-4)
                '       pos         Range (-2147483648~+2147483647)
                'Return             0correct                                -1wrong
                '******************************************************/
    Declare Function adt8949_set_actual_pos Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal pos As Long) As Long

    '//----------------------------------------------------//
                '//               Check function motion parameters
                '   //
                '//----------------------------------------------------//
                '
                '/*****************************************************
                'FunctionGet the pulse count value sent by the card
                'Parameter
                '       cardno      Card number
                '       axis        1~4 single axis
                '       pos         Pulse count
                'Return                 0correct                                 -1wrong
                '*******************************************************/
    Declare Function adt8949_get_command_pos Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByRef pos As Long) As Long

    '/*****************************************************
                'FunctionGet the actual position of each axis
                'Parameter
                '       cardno      Card number
                '       axis        axis(1-4)
                '       pos         Pointer of actual position
                'Return                 0correct                                -1wrong
                '*****************************************************/
    Declare Function adt8949_get_actual_pos Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByRef pos As Long) As Long

    '/*****************************************************
                'FunctionGet current running speed of the axis (instantaneous speed)
                'Parameter
                '       cardno      Card number
                '       axis        1~4 single axisINPA_AXISREG interpolation axis
                '       speed       Instantaneous speed, unit: mm/sec
                'Return                 0correct                                 -1wrong
                '*****************************************************/
    Declare Function adt8949_get_speed Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByRef speed As Single) As Long

    '/*****************************************************
                'FunctionGets the current interpolation motion index information

                'Parameter
                '       cardno     card number
                '       index       The pointer to the index information (0-65535)
                'Return                 0correct                              -1error
                'RemarksThis function is used for processing synchronous display use G code, cannot be used for precise localization of trajectory
                '*****************************************************/
    Declare Function adt8949_get_inp_index Lib "adt8949.dll" (ByVal cardno As Long, ByRef index As Long) As Long
    


    '//----------------------------------------------------//
                '//                  Drive function                      //
                '//----------------------------------------------------//
                '
                '/****************************************************
                'FunctionSingle axis quantitative relative motion (PTP)
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1~4)
                '       pos      >0: positive motion, <0: negative motion, Range (+/- 9999999.999mm)
                'Return                 0correct                                -1wrong
                '*****************************************************/
    Declare Function adt8949_pmove Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal pos As Single) As Long

    '/****************************************************
                'FunctionAbsolute coordinates quantitative driving, unit: mm
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1-4)
                '       pos         Unit: mm, (+/- 9999999.999) >0: positive driving, <0: negative driving
                'Return                 0correct                                -1wrong
                '*****************************************************/
    Declare Function adt8949_abs_pmove Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal pos As Single) As Long

    '/********************************************************************
                'FunctionSingle axis continuous driving
                'Parameter
                '       cardno                          Card number
                '       axis                            Axis number (1-4)
                '       dir                             >0: positive driving, <0: negative driving
                '
                'Return   0correct                             -1wrong
                'Note: Before writing drive command, be sure to set the speed parameters properly
                '********************************************************************/
    Declare Function adt8949_continue_move Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long, ByVal dir As Long) As Long

        '/*****************************************************
                'Function stop in deceleration
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1~4)
                'Return                 0correct                                 -1wrong
                'Remarks    If the set axis participates in the interpolation, other corresponding axes in the interpolation will be decelerated to stop.
                '*******************************************************/
    Declare Function adt8949_dec_stop Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long) As Long


    '/*******************************************************
                'Functionstop in sudden
                'Parameter
                '       cardno      Card number
                '       axis        Axis number (1~4)
                'Return                 0correct                                 -1wrong
                'Remarks    If the set axis participates in the interpolation, other corresponding axes in the interpolation will be decelerated to stop.
                '*********************************************************/
    Declare Function adt8949_sudden_stop Lib "adt8949.dll" (ByVal cardno As Long, ByVal axis As Long) As Long

    '/*******************************************************
                'FunctionSet cache segments of interpolation; default: 0
                'Parameter cardno          Card number
                '               prec         Preview segments(0-50)The default value is 0, the closing speed foresight;

                'Remarks: Buffer segment number does not represent the capacity of the cache, for small line segments, suggest set up more than 30 pieces, be helpful for the continuity of interpolation;
                '            Start after the pretreatment, calling function adt8949_set_acc_constraint (...). Adjust the axial acceleration constraint value, to improve processing efficiency and stability of machine tools;

                '              Setup is effective at a time, without having to repeat Settings.
                '*********************************************************/
    Declare Function adt8949_set_precount Lib "adt8949.dll" (ByVal cardno As Long, ByVal prec As Long) As Long

    '/*****************************************************
                'FunctionSet follow axis
                'Parameter
                '       cardno      Card number
                '       slaveaxis   Slave axis (following master axis), Axis number (1-4)
                '       masteraxis  Master axis (followed by slave axis), Axis number (0-4), 0: cancel follow
                'Return                 0correct                                -1wrong
                '*******************************************************/
    Declare Function adt8949_set_follow_axis Lib "adt8949.dll" (ByVal cardno As Long, ByVal slaveaxis As Long, ByVal masteraxis As Long) As Long


    '/*********************************************************
                'FunctionQuery margin in interpolation cache zone
                'Parameter
                '       cardno      Card number
                '       len         Cache length variable to be gotten
                'Return                 0correct                                NO 0wrong
                'RemarksThe interpolation cache zone has 10000 segments in total. Interpolation data and cache events are stored in different regions of the control card.
                '         An arc occupies four segments of cache space, and a full circle occupies eight segments of cache space. It is recommended to issue motion data when the cache margin is greater than 8 segments.
                '          This function is used to query API. For consecutive query, insert a Sleep(1) sentence between two queries.
                '*********************************************************/
    Declare Function adt8949_get_fifo_len Lib "adt8949.dll" (ByVal cardno As Long, ByRef lenght As Long) As Long

    '/*********************************************************
                'FunctionSet four-axis interpolation instruction (relative position)
                'Parameter
                '       cardno      Card number
                '       index       index infoused to indicate this driving infomationusually set to 0
                '       pos1,pos2,pos3,pos4 indicate the distance of XYZA axis  unit : mm
                'Return                 0correct                                -1wrong
                'Remarksif the follow axis has settedthe pos of the follow axis should be set to 0otherwise return failure
                '*********************************************************/
    Declare Function adt8949_inp_move4 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal pos1 As Single, ByVal pos2 As Single, ByVal pos3 As Single, ByVal pos4 As Single) As Long

    '/*********************************************************
                'FunctionSet four-axis interpolation instruction (absolute position)
                'Parameter
                '       cardno      Card number
                '       index       index infoused to indicate this driving infomationusually set to 0
                '       axismap     Axis mapping bit, bit0 indicates 1# axis, bit1 indicates 2# axis
                '       pos1,pos2 pos3,pos4  Absolute position of the motor

                'Return                 0correct                                -1wrong
                'note:if the follow axis has setted the pos of the follow axis should be set to 0
                '*********************************************************/
    Declare Function adt8949_inp_abs_move4 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal axismap As Long, ByVal pos1 As Single, ByVal pos2 As Single, ByVal pos3 As Single, ByVal pos4 As Single) As Long

    '/*********************************************************
    'FunctionSet four-axis interpolation instruction specifying motion time
    'Parameter
    '   cardno      Card number
    '   index       Data index, used to identify the data of the motion, generally set to 0 to
    '   pulse1,pulse2,pulse3,pulse4 indicate the relative distance of axis XYZW
    '   time        Time required by motion of the straight line, unit: ms
    'Return                     0correct                                -1wrong
    'Note: The straight line moves at constant speed within the specified time. Before calling this function, ensure that the number of preprocessing segments is zero,
    '       or else the call will fail;If synchronized axis is set, pos parameter of slave axis should be set to 0, or else the call will fail.

    '*********************************************************/
    Declare Function adt8949_time_move4 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal pos1 As Single, ByVal pos2 As Single, ByVal pos3 As Single, ByVal pos4 As Single, ByVal time As Single) As Long

    '/*********************************************************
                'FunctionFour-axis absolute coordinates linear interpolation (specifying motion time)
                'Parameter
                '       cardno      Card number
                '       index       Data index, used to identify the data of the motion, generally set to 0 to
                '       axismap      Axis mapping bit, bit0 indicates 1# axis, bit1 indicates 2# axis; if the axis is not marked, the target position will not take effect.
                '       pulse1,pulse2,pulse3,pulse4 indicate the coordinates that axis XYZW move to
                '       time         Time required by motion of the straight line (non-cumulative time), unit: ms
                'Return                 0correct                                -1wrong
                'Note: The straight line moves at constant speed within the specified time. Before calling this function, ensure that the number of preprocessing segments is zero, or else the call will fail.
                '       If synchronized axis is set, pos parameter of slave axis should be set to 0, and axismap value doesn't need to consider the slave axis position.
                '*********************************************************/*********************************************************/
    Declare Function adt8949_time_abs_move4 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal axismap As Long, ByVal pos1 As Single, ByVal pos2 As Single, ByVal pos3 As Single, ByVal pos4 As Single, ByVal time As Single) As Long

    '/*********************************************************
                'FunctionTwo-axis arc interpolation, unit: mm
                'Parameter
                '       cardno      Card number
                '       index       Data index, used to identify the data of the motion, generally set to 0 to
                '       axismap     Axis selection mapping flag, mark any two axes in the space for plane arc interpolation
                '       pos         Target point coordinates of the arc (relative to the current point)
                '       Center      Center coordinates of the arc (relative to the current point)
                '       dir         Arc direction (1: clockwise; 0: counterclockwise)
                'Return                 0correct                                 Non-0wrong
                'RemarksAxismap: axis mapping. AZYX correspond to binary. 0011 indicates that X,
                '   Y axis participate in two-axis arc interpolation, 0110 indicates that Y, Z axis participate in two-axis arc interpolation
                '*********************************************************/
    Declare Function adt8949_inp_arc2 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal arcmap As Long, ByRef pos As Single, ByRef Center As Single, ByVal dir As Long) As Long

    '/*********************************************************
                'FunctionTwo shaft absolute coordinates of arc interpolation

                'Parameter
                '       cardno      card number
                '       index          Index information, used to identify the motion information, generally can be set to 0

                '       axismap        Shaft choose map symbol, shaft bit0 said 1, 2 axis, bit1 said... , two axes do planes can sign space circular arc interpolation

                '       pos                    Arc absolute coordinates of target, the unit is mm

                '       Center        Absolute coordinates the center of the arc, the unit is mm

                '       dir                     Arc direction (1 to 0 clockwise counterclockwise)

                'Return                 0correct                           Non-zero: error

                'RemarksA circular arc takes 4 period of cache space, a full circle takes 8 period of cache space
                '         If you call this function to draw a complete the plane of the circle, the pretreatment of the need to set a certain buffer period of number, otherwise go semicircle deceleration process occurs.

                '*********************************************************/
    Declare Function adt8949_inp_abs_arc2 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal arcmap As Long, ByRef pos As Single, ByRef Center As Single, ByVal dir As Long) As Long

    '/*********************************************************
                'FunctionThree-axis arc interpolation instruction
                'Parameter
                '       cardno      Card number
                '       index       ata index, used to identify the data of the motion, generally set to 0
                '       arcmap          Arc participating in axes mapping mark
                '       pos2            Coordinates of second point (relative to current point)
                '       pos3            Coordinates of third point (relative to current point)
                '       arc_flag        0:  arc                                1circle
                'Return                 0correct                                 Non-0wrong
                'Remarks: one segment of arc contains four segment caches
                '*********************************************************/
    Declare Function adt8949_inp_arc3 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal arcmap As Long, ByRef pos2 As Single, ByRef pos3 As Single, ByVal arc_flag As Long) As Long

    '/*********************************************************
                'FunctionThree-axis arc interpolation instruction
                'Parameter
                '       cardno      Card number
                '       index       Data index, used to identify the data of the motion, generally set to 0
                '       arcmap      Axis selection mapping flag, mark any two axes in the space for plane arc interpolation
                '       pos2        Coordinates of second point (absolute to current point)
                '       pos3        Coordinates of third point (absolute to current point)
                '       arc_flag        0: arc                                 1circle
                'Return                 0correct                                 Non-0wrong
                'Remarksone segment of arc contains four segment caches
                '*********************************************************/
    Declare Function adt8949_inp_abs_arc3 Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal arcmap As Long, ByRef pos2 As Single, ByRef pos3 As Single, ByVal arc_flag As Long) As Long

    '/*********************************************************
                'FunctionGet arc length of two axes
                'Parameter
                '       axismap        Axis selection mapping flag, mark any two axes in the space for plane arc interpolation
                '       pos            Target point coordinates of the arc (relative to the current point)
                '       Center         Center coordinates of the arc (relative to the current point)
                '       dir            Arc direction (1: clockwise; 0: counterclockwise)
                '       length         Arc length of two axes
                'Return                 0correct                                Non-0wrong
                '*********************************************************/
    Declare Function adt8949_get_arc2_length Lib "adt8949.dll" (ByVal arcmap As Long, ByRef pos As Single, ByRef Center As Single, ByVal dir As Long, ByRef length As Single) As Long

    '/*********************************************************
                'FunctionGet arc length of three axes
                'Parameter
                '       arcmap          Axis selection mapping flag; up to three positions can be marked as 1, that is, support arc interpolation of up to three axes
                '       pos2            Second point coordinates of the arc (relative to the current point)
                '       pos3            Third point coordinates of the arc (relative to the current point)
                '       length          Arc length of three axes
                '       arc_flag        0: arc                               1circle
                'Return                 0correct                                Non-0wrong
                '*********************************************************/
    Declare Function adt8949_get_arc3_length Lib "adt8949.dll" (ByVal arcmap As Long, ByRef pos2 As Single, ByRef pos3 As Single, ByRef length As Single, ByVal arc_flag As Long) As Long

    '/*********************************************************
                'FunctionNURBS interpolation
                'Parameter
                '       cardno      Card number
                '       index       Data index, used to identify the data of the motion, generally set to 0
                '       axismap     Axis selection mapping flag, only three positions can be marked to 1, that is, support NURBS interpolation up to three axes
                '       conp        Spline control point (relative to the current point, the coordinates of first control point should be 0, or else it will return error)
                '       weight      Weight corresponding to control point of spline. The weight of each control point of AutoCAD is -1 by default
                '       node        Node value of spline
                '       nodenum     Number of spline nodes
                'Return                 0correct                                 Non-0wrong
                'RemarksFor NURBS interpolation, it is recommended to set a bigger number of pre-processing cache segments and use trapezoidal acceleration/deceleration mode;
                '         calling the function to set arc speed clamp will affect planning of spline interpolation speed;
                '         Using spline interpolation will occupy a larger number of cache segments of control card.
                '        To continue to call interpolation instruction, check the remaining cache capacity in advance.
                '*********************************************************/
    Declare Function adt8949_inp_NURBS Lib "adt8949.dll" (ByVal cardno As Long, ByVal index As Long, ByVal arcmap As Long, ByRef conp() As Single, ByRef weight As Single, ByRef node As Single, ByVal nodenum As Long) As Long

        '//-------------------------------------------------//
                '//          Switch input and output class  //

                '//-------------------------------------------------//
                '
                '/*********************************************************
                'FunctionGet input IO status (adt8949_read_bit)
                'Parameter
                '       cardno      Card number
                '       number      Input point (0-47), including 0 to 18, 36-47 for quick input points, 19-35 input point for the bus

                '                              Among them, four drive shaft encoder signal phase (A, B, Z) corresponding to the port as follows:

                '                                       IN36IN39:     A1...A4
                '                                       IN40IN43:     B1...B4
                '                                       IN44IN47:     Z1...Z4
                'Return                 0low voltage level                1high voltage level
                '*********************************************************/
    Declare Function adt8949_read_bit Lib "adt8949.dll" (ByVal cardno As Long, ByVal number As Long) As Long
    
     '/*****************************************************
                'FunctionGet output IO status (gadt8949_et_out)
                'Parameter
                '       cardno      Card number
                '       number        Output point (0-31), which is suitable for rapid output points, 0 to 14 15 to 31 points for bus output

                'Return                Return value: the current state of the specified port, 1 said parameter error

                'Remarks
                '*****************************************************/
    Declare Function adt8949_get_out Lib "adt8949.dll" (ByVal cardno As Long, ByVal number As Long) As Long
    
    '/********************************************************
                'FunctionRead IO status by groups
                'Parameter
                '       cardno      Card number
                '       gp          Group number (the number of OUT0~OUT15 is 0, the number of IN0~IN15 is 0x20, the number of IN16~IN31 is 0x21)
                '       levelmap    Status of this group of IO (determine the status of certain IO through bit value, e.g. OUT0 corresponds to bit0, OUT15 corresponds to bit15)
                'Return                 0correct                        -1wrong
                'RemarkslevelmapFor 16-bit signed short plastic data, to Mosaic the 32-bit data and on the low 16 bits, required for operation: levelmap & 0 XFFFF, lest affect high 16 bit data

                '*********************************************************/
    Declare Function adt8949_get_gpio Lib "adt8949.dll" (ByVal cardno As Long, ByVal gp As Long, ByRef levelmap As Long) As Long

    '/********************************************************
                'FunctionSet output IO status (adt8949_write_bit)
                'Parameter
                '       cardno      Card number
                '       number      Output point (0-31), which is suitable for rapid output points, 0 to 14 15 to 31 points for bus output

                '       value       0: close                             1: open
                'Return                 0correct                         -1wrong
                '*********************************************************/
    Declare Function adt8949_write_bit Lib "adt8949.dll" (ByVal cardno As Long, ByVal number As Long, ByVal Value As Long) As Long

    '/********************************************************
                'FunctionOperate output by group
                'Parameter
                '       cardno      Card number
                '       gp          Group number
                '                   OUT0OUT15group id is 0
                '                   OUT16OUT31group id is 1
                '       levelmap         Voltage level setting of this group of IO (determine the status of certain output point through bit value, e.g. OUT0 corresponds to bit0, OUT15 corresponds to bit15); only the output points with iomap bit value 1 are affected
                'Return                 0correct                         -1wrong
                '*********************************************************/
    Declare Function adt8949_set_gpio Lib "adt8949.dll" (ByVal cardno As Long, ByVal gp As Long, ByVal levelmap As Long) As Long

    '/********************************************************
                'FunctionSet voltage level for multiple output points at the same time
                'Parameter
                '       cardno      Card number
                '       gp          group number
                '                   OUT0OUT15group number is 0
                '                   OUT16OUT31group number is 1
                '       iomap       Specify the output point to be operated by bit (bit0~bit15); if the bit value is 1, operate corresponding output point; if the bit value is 0, output point isn't affected
                '       levelmap    Voltage level setting of this group of IO (determine the status of certain output point through bit value,
                '                   e.g. OUT0 corresponds to bit0, OUT15 corresponds to bit15); only the output points with iomap bit value 1 are affected
                'Return                 0correct                         -1wrong
                '*********************************************************/
    Declare Function adt8949_set_multi_io Lib "adt8949.dll" (ByVal cardno As Long, ByVal gp As Long, ByVal iomap As Long, ByVal levelmap As Long) As Long

    '//-------------------------------------------------//
                '//                 Set the cache event
                '//-------------------------------------------------//
                '
                '/*********************************************************
                'FunctionQuery cache event area remaining paragraphs 1000 number

                'Parameter
                '       cardno     card number
                '       len                    A pointer to the cache event length variable to get

                'Return                 0correct                                Non-zero: error

                'RemarksInterpolation data and cache events in different areas of the control card;

                '        Set the cache event functions are:

                '                       adt8949_set_fifo_io()
                '                       adt8949_set_fifo_multi_io()
                '                       adt8949_set_fifo_delay()
                '                       adt8949_set_fifo_pulser()
                '         The function as part of the inquiry API, for continuous sci-tech novelty search, query twice middle suggest inserting a Sleep (1) statements.

                '*********************************************************/
    Declare Function adt8949_get_fifo_event_len Lib "adt8949.dll" (ByVal cardno As Long, ByRef length As Long) As Long
    
    '/********************************************************
                'FunctionSingle point IO output in interpolation
                'Parameter
                '       cardno      Card number
                '       number      Output point (0-14)
                '       value       0: close           1: open
                '       speed       -1: no speed constraint before motion by default, other: range (0.0-100000.0 mm/sec)
                'Return                 0correct                         -1wrong
                'RemarksSpeed setting is same as the motion track speed, and motion track won't decelerate. If the speed setting is smaller,
                '       the motion track will decelerate to the set speed in advance before corresponding IO operation, and then accelerate to motion track speed, and form V-shaped process.
                '*********************************************************/
    Declare Function adt8949_set_fifo_io Lib "adt8949.dll" (ByVal cardno As Long, ByVal number As Long, ByVal Value As Long, ByVal speed As Single) As Long

    '/********************************************************
                'FunctionSingle point IO output in interpolation
                'Parameter
                '       cardno      Card number
                '       gp          Group number (the number of OUT0~OUT14 is 0; only output point settings of group are available)
                '       iomap       Specify the output point to be operated by bit (bit0~bit15); if the bit value is 1,
                '                   perate corresponding output point; if the bit value is 0, output point isn't affected
                '       levelmap    Voltage level setting of this group of IO (determine the status of certain output point through bit value,
                '                   e.g. OUT0 corresponds to bit0, OUT15 corresponds to bit15); only the output points with iomap bit value 1 are affected
                '       speed       -1: no speed constraint before motion by default, other: range (0.0-100000.0 mm/sec)
                'Return                 0correct                        -1wrong
                'RemarksSpeed setting is same as the motion track speed, and motion track won't decelerate. If the speed setting is smaller,
                '           the motion track will decelerate to the set speed in advance before corresponding IO operation,
                '           and then accelerate to motion track speed, and form V-shaped process.
                '*********************************************************/
    Declare Function adt8949_set_fifo_multi_io Lib "adt8949.dll" (ByVal cardno As Long, ByVal gp As Long, ByVal iomap As Long, ByVal levelmap As Long, ByVal speed As Single) As Long

    '/********************************************************
                'FunctionSpecific position delay motion in interpolation
                'Parameter
                '       cardno           Card number
                '       millisecond      delay time, unit: ms
                'Return                 0correct                         -1wrong
                'RemarksSingle control card FIFO capacity of a total of 1000 events, if the function return value is non-zero, represents the event buffer is full, need to cache events have allowance.

                '        The query cache event area remaining number can call a function adt8949_get_fifo_event_len()
                '*********************************************************/
    Declare Function adt8949_set_fifo_delay Lib "adt8949.dll" (ByVal cardno As Long, ByVal millisecond As Long) As Long

    '/********************************************************
                'FunctionInsert pulse generator in interpolation
                'Parameter
                '       cardno                  Card number
                '       port                    Output point port of pulse generator (0-14)
                '       NormalLevel             Normal state voltage level   0: Low, 1: High
                '       NormalTime              Holding time of normal level, unit: ms
                '       UnNormalTime            Holding time of non-normal level, unit: ms
                '       ReverseNum              Reverse times of output level
                '       speed                   -1: no speed constraint before motion by default, other: range (0.0-100000.0 mm/sec)
                'Return0correct               -1wrong
                'RemarksSpeed setting is same as the motion track speed, and motion track won't decelerate.
                '           If the speed setting is smaller, the motion track will decelerate to the set speed in advance before corresponding IO operation,
                '           and then accelerate to motion track speed, and form V-shaped process.
                '*********************************************************/
    Declare Function adt8949_set_fifo_pulser Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long, ByVal NormalLevel As Long, ByVal NormalTime As Long, ByVal UnNormalTime As Long, ByVal ReverseNum As Long, ByVal speed As Single) As Long

    '/********************************************************
                'FunctionSet DA output voltage
                'Parameter
                '       cardno          Card number
                '       port            Set DA output port (1-2)
                '       value           Set DA output size (0-10), unit: V
                'Return                 0correct                                 Non-0wrong
                'Remarks DA output voltage is accurate to two decimal places
                '*********************************************************/
    Declare Function adt8949_set_daout Lib "adt8949.dll" (ByVal cardno As Long, ByVal port As Long, ByVal Value As Single) As Long



    '//-------------------------------------------------//
                '//              Back to the origin function//
                '//-------------------------------------------------//
                '
                '/********************************************************
                'FunctionSet home signal, step parameter
                'Parameter
                '       m_nCardNum                      Card number
                '       m_nAxisNum                      Axis number
                '       m_nHomeDir                      Home direction, 0: negative direction, 1: positive direction
                '       m_nStop0Active          stop0 active level setting; 0: Low level stop; 1: High level stop
                '       m_nLimitActive          limit signal active level setting; 0: Low level stop; 1: High level stop
                '       m_nStop1Active          stop1 active level setting; 0: Low level stop; 1: High level stop
                '       m_fBackRange            Reverse distance >1, shouldn't exceed the distance between positive limit and stop0
                '       m_fEncoderZRange        Encoder Z phase range >1
                '       m_fOffset               Home offset; ==0: No, >0: positive direction, <0: negative direction
                'Return         0correct        -1 ~ -8error type-x  x parameter error
                '*********************************************************/
    Declare Function adt8949_SetHomeMode_Ex Lib "adt8949.dll" (ByVal m_nCardNum As Long, ByVal m_nAxisNum As Long, ByVal m_nHomeDir As Long, ByVal m_nStop0Active As Long, ByVal m_nLimitActive As Long, ByVal m_nStop1Active As Long, ByVal m_nBackRange As Single, ByVal m_fEncoderZRange As Single, ByVal m_fOffset As Single) As Long
                                            
                                            
    '/********************************************************
                'FunctionSet speed parameters in home
                'Parameter
                '       m_nCardNum                              Card number
                '       m_nAxisNum                              Axis number
                '       m_fStartSpeed                           Home (STOP0) search start speed
                '       m_fSearchSpeed                          Home search speed
                '       m_fHomeSpeed                            Slow homing speed
                '       m_fAcc                                  Acceleration in homing process
                '       m_fZPhaseSpeed                          Encoder Z phase (STOP1) search speed
                'Return         0correct                         -1~-7-x  x parameter error
                '*********************************************************/
    Declare Function adt8949_SetHomeSpeed_Ex Lib "adt8949.dll" (ByVal m_nCardNum As Long, ByVal m_nAxisNum As Long, ByVal m_fStartSpeed As Single, ByVal m_fSearchSpeed As Single, ByVal m_fHomeSpeed As Single, ByVal m_fAcc As Single, ByVal m_fZPhaseSpeed As Single) As Long

    '/********************************************************
                'Functionstart home process
                'Parameter
                '       m_nCardNum                             Card number
                '       m_nAxisNum                             Axis number
                '       m_fGear                                Electronic gear ratio:(1-10000)
                'Return  0: Correct      -1~-3: Parameter error-x: x parameter error

                'RemarksCall this function when start back to zero, start after need regular call adt8949_GetHomeStatus_Ex()Until back to zero
                '*********************************************************/
    Declare Function adt8949_HomeProcess_Ex Lib "adt8949.dll" (ByVal m_nCardNum As Long, ByVal m_nAxisNum As Long, ByVal m_fGear As Single) As Long

    '/********************************************************
                'FunctionGet the status of home
                'Parameter
                '       m_nCardNum                              Card number
                '       m_nAxisNum                              Axis number
                'Return         0:Home successfully-1: Parameter 1 errorParameter 2 errorHoming isn't started;
                '                       (1-10) steps:
                '                       1: Approach home fast and search STOP0
                '                       2: Check if STOP0 is found
                '                       3: Exit home reversely
                '                       4: Check if reverse exit is complete
                '                       5: Approach home slowly and search STOP0
                '                       6: Check if STOP0 searching completes
                '                       7: Approach Z phase slowly, and search STOP1. If STOP1 is set to -1, skip step 7 & 8.
                '                       8: Check if STOP1 searching completes
                '                       9: Home offset
                '                       10: Check home offset
                '                  -100x: The x homing step is abnormal, e.g.: -1001: the first homing step is abnormal
                '                  -1020: Homing is terminated
                'RemarksNeed to call regularly, in the process of back to zero until back to zero

                '*********************************************************/
    Declare Function adt8949_GetHomeStatus_Ex Lib "adt8949.dll" (ByVal m_nCardNum As Long, ByVal m_nAxisNum As Long) As Long

Public Sub MyProc()

    DoEvents

End Sub

